#!/bin/sh
#set -xv

source /etc/update/update.env
/bin/sync

exec 3>&1 4>&2
trap 'exec 2>&4 1>&3' 0 1 2 3
exec 1>>${UPDATE_DIR}/update.log 2>&1

#
# post_script.sh
#

USB_RESTORE_ENABLED=0

# Check for Auto Update partitions to see if we need to force a system reboot.
# These partitions will not exist when flashing the first time with the new
# auto update firmware.
if [ ! -b "/dev/mmcblk0p7" ] || [ ! -b "/dev/mmcblk0p8" ]; then
	echo "AUTO UPDATE PARTITIONS DO NOT EXIST"
	echo "REBOOT REQUIRED - REBOOTING THE SYSTEM NOW"
	echo "THIS IS FIRST TIME THROUGH AUTO UPDATE FLASHING PROCESS"
	/bin/sync
	# Flag to force re-running manual flash process automatically.
	echo -n -e \\xff > /mnt/rootfs/home/qlx/cfg/AutoUpdate
	/bin/sync
	export LD_LIBRARY_PATH=/mnt/rootfs/usr/lib
	/bin/sync
	/mnt/rootfs/usr/bin/fbv -i -s 10 /mnt/rootfs/home/qlx/boot/Halt_Usb.png
	/sbin/reboot
	sleep 20
	exit 0
fi

#
# Move alibi from /mnt/databTMP to /mnt/auditTMP (audit) partition - if present.
# We need to make the mount points & mount them first.
#
mkdir -p /mnt/auditTMP
mkdir -p /mnt/databTMP
mount -o defaults,barrier=1 /dev/mmcblk0p2 /mnt/auditTMP
mount -o defaults,barrier=1 /dev/mmcblk0p3 /mnt/databTMP

# move alibi file if in wrong partition
if [ -f /mnt/databTMP/alibi ]; then
	mv -f /mnt/databTMP/alibi /mnt/auditTMP/alibi
fi
# sync before the delete - just in case
/bin/sync

# If we are doing a backup & restore settings,
# set variable so we DO NOT remove database files.
# The drop_file is created in the 10-USB-PostUpdate.sh script.
if [ -f /tmp/USB_RESTORE_ENABLED ]; then
	USB_RESTORE_ENABLED=1
	/bin/sync
	rm -f /tmp/USB_RESTORE_ENABLED
	/bin/sync
fi

# If $AUTO_UPDATE does not exist - default it to 0.
# This will happen if current bootloader is v4.00.00 or older.
if [ -z ${AUTO_UPDATE} ]; then
	AUTO_UPDATE=0
fi

# Only do this for USB device firmware updates
# when restore settings is NOT enabled.
if [ ${AUTO_UPDATE} -ne 1 ] && [ ${USB_RESTORE_ENABLED} -ne 1 ]; then
	# Remove contents of /mnt/databTMP (database) partition.
	# rm -f /mnt/databTMP/*
	# Check if the glob gets expanded to existing files.
	# If not, 'file' here will be exactly the pattern we
	# searched for and the 'exists' test will evaluate to false.
	for file in /mnt/databTMP/*; do
		if [ -f "$file" ]; then
			rm -f $file
		fi
	done
	echo ""
	echo "Database partition cleaned."
	echo ""

	# Remove contents of /mnt/auditTMP (audit) partition
	# except for: CRC, alibi and audit.
	rm -f $(find /mnt/auditTMP -type f -not \( -name 'CRC' -or -name 'alibi' -or -name 'audit' \))
	echo "Audit partition cleaned as needed."
	echo ""
else
	echo ""
	echo "Database partition files retained."
	echo ""
fi
/bin/sync

# This removes a CRC file of size zero.
# The file does exist, but is empty.
if [ ! -s /mnt/auditTMP/CRC ]; then
	rm /mnt/auditTMP/CRC
fi

# If there are 3 lines in the CRC file,
# remove only the first one.
# CRC for parm.txt is no longer stored here.
if [ -f /mnt/auditTMP/CRC ]; then
	tail -n2 /mnt/auditTMP/CRC > /mnt/auditTMP/CRC_new
	/bin/sync
	mv -f /mnt/auditTMP/CRC_new /mnt/auditTMP/CRC
	echo ""
	echo "CRC file adjusted for moved config file."
	echo ""
	/bin/sync
fi

# Create ftpuser directory if it does not exist.
mkdir -p /mnt/ftpdir
mount -o defaults,barrier=1 /dev/mmcblk0p6 /mnt/ftpdir
if [ ! -d /mnt/ftpdir/ftpuser ]; then
	mkdir -p /mnt/ftpdir/ftpuser
	echo "Fixed missing ftpuser directory."
	echo ""
	/bin/sync
fi

#
# Remove the following files for a clean system bring up.
# File system paths MUST be prefixed with /mnt/rootfs.
#
if [ -f /mnt/rootfs/home/qlx/cfg/parm.txt ]; then
	rm /mnt/rootfs/home/qlx/cfg/parm.txt
fi

if [ -f /mnt/rootfs/home/qlx/apps/startup.cod ]; then
	rm /mnt/rootfs/home/qlx/apps/startup.cod
fi

if [ -f /mnt/rootfs/home/qlx/cfg/StoredMemory ]; then
	rm /mnt/rootfs/home/qlx/cfg/StoredMemory
fi

# Check if the glob gets expanded to existing files.
# If not, 'file' here will be exactly the pattern we
# searched for and the 'exists' test will evaluate to false.
for file in /mnt/rootfs/home/qlx/cfg/ocds*; do
	if [ -e "$file" ]; then
		rm /mnt/rootfs/home/qlx/cfg/ocds*
	fi
	# This is all we needed to know, so we can break after the first iteration
	break
done

if [ -f /mnt/rootfs/home/qlx/cfg/qlxuihost.conf ]; then
	rm /mnt/rootfs/home/qlx/cfg/qlxuihost.conf
fi

/bin/sync
exit 0
